/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.util;

import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import slimeknights.tconstruct.library.tools.capability.ToolCapabilityProvider;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;

public class TinkerToolFluxed
implements ToolCapabilityProvider.IToolCapabilityProvider,
IEnergyStorage {
    protected final Supplier<? extends IToolStackView> tool;
    private final LazyOptional<IEnergyStorage> capOptional;
    public static final String STORED_ENERGY_KEY = "tooltip.materialis.stored_enegry";
    public static final ResourceLocation MAX_ENERGY = new ResourceLocation("materialis", "max_energy");
    public static final ResourceLocation STORED_ENERGY = new ResourceLocation("materialis", "stored_energy");
    public static final ResourceLocation ENERGY_OWNER = new ResourceLocation("materialis", "energy_owner");
    private static final int MAX_TRANSFER_RATE = 1000;

    public TinkerToolFluxed(ItemStack stack, Supplier<? extends IToolStackView> toolStack) {
        this.tool = toolStack;
        this.capOptional = LazyOptional.of(() -> this);
    }

    public <T> LazyOptional<T> getCapability(IToolStackView tool, Capability<T> cap) {
        if (tool.getVolatileData().getInt(MAX_ENERGY) > 0 && cap == CapabilityEnergy.ENERGY) {
            return CapabilityEnergy.ENERGY.orEmpty(cap, this.capOptional);
        }
        return LazyOptional.empty();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return TinkerToolFluxed.receiveEnergy(this.tool.get(), maxReceive, simulate);
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return TinkerToolFluxed.getEnergyStored(this.tool.get());
    }

    public int getMaxEnergyStored() {
        return TinkerToolFluxed.getMaxEnergyStored(this.tool.get());
    }

    public static int receiveEnergy(IToolStackView tool, int maxReceive, boolean simulate) {
        int energyStored = TinkerToolFluxed.getEnergyStored(tool);
        int energyReceived = Math.min(TinkerToolFluxed.getMaxEnergyStored(tool) - energyStored, Math.min(1000, maxReceive));
        if (!simulate) {
            ModDataNBT persistentData = tool.getPersistentData();
            persistentData.putInt(STORED_ENERGY, energyStored + energyReceived);
        }
        return energyReceived;
    }

    public static boolean removeEnergy(IToolStackView tool, int energyRemoved, boolean simulate, boolean drain) {
        int energyStored = TinkerToolFluxed.getEnergyStored(tool);
        if (energyStored < energyRemoved) {
            if (drain && !simulate) {
                ModDataNBT persistentData = tool.getPersistentData();
                persistentData.putInt(STORED_ENERGY, 0);
            }
            return false;
        }
        if (!simulate) {
            ModDataNBT persistentData = tool.getPersistentData();
            persistentData.putInt(STORED_ENERGY, energyStored - energyRemoved);
        }
        return true;
    }

    public static int getEnergyStored(IToolStackView tool) {
        ModDataNBT persistentData = tool.getPersistentData();
        if (persistentData.contains(STORED_ENERGY, 3)) {
            return persistentData.getInt(STORED_ENERGY);
        }
        return 0;
    }

    public static int getMaxEnergyStored(IToolStackView tool) {
        IModDataView volatileData = tool.getVolatileData();
        if (volatileData.contains(MAX_ENERGY, 3)) {
            return volatileData.getInt(MAX_ENERGY);
        }
        return 0;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return true;
    }
}

